{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.ShellAPI platform;

interface

uses
  System.Text, System.Runtime.InteropServices, Windows;


type
  HDROP = Longint;

function DragQueryFile(Drop: HDROP; FileIndex: UINT; FileName: StringBuilder; cb: UINT): UINT;
function DragQueryFileA(Drop: HDROP; FileIndex: UINT; FileName: StringBuilder; cb: UINT): UINT;
function DragQueryFileW(Drop: HDROP; FileIndex: UINT; FileName: StringBuilder; cb: UINT): UINT;
function DragQueryPoint(Drop: HDROP; out Point: TPoint): BOOL;
procedure DragFinish(Drop: HDROP);
procedure DragAcceptFiles(Wnd: HWND; Accept: BOOL);

function ShellExecute(hWnd: HWND; Operation, FileName, Parameters,
  Directory: string; ShowCmd: Integer): HINST; overload;
function ShellExecute(hWnd: HWND; Operation: IntPtr; FileName, Parameters,
  Directory: string; ShowCmd: Integer): HINST; overload;
function ShellExecute(hWnd: HWND; Operation, FileName: string; Parameters: IntPtr;
  Directory: string; ShowCmd: Integer): HINST; overload;
function ShellExecute(hWnd: HWND; Operation: IntPtr; FileName: string; Parameters: IntPtr;
  Directory: string; ShowCmd: Integer): HINST; overload;
function ShellExecute(hWnd: HWND; Operation: IntPtr; FileName: string; Parameters: IntPtr;
  Directory: IntPtr; ShowCmd: Integer): HINST; overload;
function ShellExecute(hWnd: HWND; Operation: string; FileName: string; Parameters: string;
  Directory: IntPtr; ShowCmd: Integer): HINST; overload;
function ShellExecuteA(hWnd: HWND; Operation, FileName, Parameters,
  Directory: string; ShowCmd: Integer): HINST;
function ShellExecuteW(hWnd: HWND; Operation, FileName, Parameters,
  Directory: string; ShowCmd: Integer): HINST; 
function FindExecutable(FileName, Directory: string; Result: StringBuilder): HINST; 
function FindExecutableA(FileName, Directory: string; Result: StringBuilder): HINST;
function FindExecutableW(FileName, Directory: string; Result: StringBuilder): HINST;
function CommandLineToArgvW(lpCmdLine: string; out pNumArgs: Integer): IntPtr; { PPWideChar }
function ShellAbout(Wnd: HWND; szApp, szOtherStuff: string; Icon: HICON): Integer;
function ShellAboutA(Wnd: HWND; szApp, szOtherStuff: string; Icon: HICON): Integer;
function ShellAboutW(Wnd: HWND; szApp, szOtherStuff: string; Icon: HICON): Integer;
function DuplicateIcon(hInst: HINST; Icon: HICON): HICON;
function ExtractAssociatedIcon(hInst: HINST; lpIconPath: string;
  var lpiIcon: Word): HICON;
function ExtractAssociatedIconA(hInst: HINST; lpIconPath: string;
  var lpiIcon: Word): HICON;
function ExtractAssociatedIconW(hInst: HINST; lpIconPath: string;
  var lpiIcon: Word): HICON;
function ExtractIcon(hInst: HINST; lpszExeFileName: string;
  nIconIndex: UINT): HICON;
function ExtractIconA(hInst: HINST; lpszExeFileName: string;
  nIconIndex: UINT): HICON;
function ExtractIconW(hInst: HINST; lpszExeFileName: string;
  nIconIndex: UINT): HICON;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _DRAGINFO = record
    uSize: UINT;                 { init with SizeOf(DRAGINFO) }
    pt: TPoint;
    fNC: BOOL;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpFileList: string;
    grfKeyState: DWORD;
  end;
  TDragInfo = _DRAGINFO;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _DRAGINFOA = record
    uSize: UINT;                 { init with SizeOf(DRAGINFO) }
    pt: TPoint;
    fNC: BOOL;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpFileList: string;
    grfKeyState: DWORD;
  end;
  TDragInfoA = _DRAGINFOA;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _DRAGINFOW = record
    uSize: UINT;                 { init with SizeOf(DRAGINFO) }
    pt: TPoint;
    fNC: BOOL;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpFileList: string;
    grfKeyState: DWORD;
  end;
  TDragInfoW = _DRAGINFOW;

const
{ AppBar stuff }

  ABM_NEW           = $00000000;
  ABM_REMOVE        = $00000001;
  ABM_QUERYPOS      = $00000002;
  ABM_SETPOS        = $00000003;
  ABM_GETSTATE      = $00000004;
  ABM_GETTASKBARPOS = $00000005;
  ABM_ACTIVATE      = $00000006;  { lParam = True/False means activate/deactivate }
  ABM_GETAUTOHIDEBAR = $00000007;
  ABM_SETAUTOHIDEBAR = $00000008;  { this can fail at any time.  MUST check the result
                                     lParam = TRUE/FALSE  Set/Unset
                                     uEdge = what edge }
  ABM_WINDOWPOSCHANGED = $0000009;

{ these are put in the wparam of callback messages }

  ABN_STATECHANGE    = $0000000;
  ABN_POSCHANGED     = $0000001;
  ABN_FULLSCREENAPP  = $0000002;
  ABN_WINDOWARRANGE  = $0000003; { lParam = True means hide }

{ flags for get state }

  ABS_AUTOHIDE    = $0000001;
  ABS_ALWAYSONTOP = $0000002;

  ABE_LEFT        = 0;
  ABE_TOP         = 1;
  ABE_RIGHT       = 2;
  ABE_BOTTOM      = 3;

type
  [StructLayout(LayoutKind.Sequential)]
  _AppBarData = record
    cbSize: DWORD;
    hWnd: HWND;
    uCallbackMessage: UINT;
    uEdge: UINT;
    rc: TRect;
    lParam: LPARAM; { message specific }
  end;
  TAppBarData = _AppBarData;
  APPBARDATA = _AppBarData;

function SHAppBarMessage(dwMessage: DWORD; var pData: TAppBarData): UINT;

function DoEnvironmentSubst(szString: StringBuilder; cbString: UINT): DWORD;
function DoEnvironmentSubstA(szString: StringBuilder; cbString: UINT): DWORD;
function DoEnvironmentSubstW(szString: StringBuilder; cbString: UINT): DWORD;
function ExtractIconEx(lpszFile: string; nIconIndex: Integer;
  [out] phiconLarge, [out] phiconSmall: array of HICON; nIcons: UINT): UINT; overload;
function ExtractIconEx(lpszFile: string; nIconIndex: Integer;
  phiconLarge: IntPtr; [out] phiconSmall: array of HICON; nIcons: UINT): UINT; overload;
function ExtractIconEx(lpszFile: string; nIconIndex: Integer;
  [out] phiconLarge: array of HICON; phiconSmall: IntPtr; nIcons: UINT): UINT; overload;
function ExtractIconEx(lpszFile: string; nIconIndex: Integer;
  phiconLarge, phiconSmall: IntPtr; nIcons: UINT): UINT; overload;
function ExtractIconExA(lpszFile: string; nIconIndex: Integer;
  [out] phiconLarge, [out] phiconSmall: array of HICON; nIcons: UINT): UINT;
function ExtractIconExW(lpszFile: string; nIconIndex: Integer;
  [out] phiconLarge, [out] phiconSmall: array of HICON; nIcons: UINT): UINT;


{ Shell File Operations }

const
  FO_MOVE           = $0001;
  FO_COPY           = $0002;
  FO_DELETE         = $0003;
  FO_RENAME         = $0004;

  FOF_MULTIDESTFILES         = $0001;
  FOF_CONFIRMMOUSE           = $0002;
  FOF_SILENT                 = $0004;  { don't create progress/report }
  FOF_RENAMEONCOLLISION      = $0008;
  FOF_NOCONFIRMATION         = $0010;  { Don't prompt the user. }
  FOF_WANTMAPPINGHANDLE      = $0020;  { Fill in SHFILEOPSTRUCT.hNameMappings
                                         Must be freed using SHFreeNameMappings }
  FOF_ALLOWUNDO              = $0040;
  FOF_FILESONLY              = $0080;  { on *.*, do only files }
  FOF_SIMPLEPROGRESS         = $0100;  { means don't show names of files }
  FOF_NOCONFIRMMKDIR         = $0200;  { don't confirm making any needed dirs }
  FOF_NOERRORUI              = $0400;  { don't put up error UI }

type
  FILEOP_FLAGS = Word;

const
  PO_DELETE       = $0013;  { printer is being deleted }
  PO_RENAME       = $0014;  { printer is being renamed }
  PO_PORTCHANGE   = $0020;  { port this printer connected to is being changed
                              if this id is set, the strings received by
                              the copyhook are a doubly-null terminated
                              list of strings.  The first is the printer
                              name and the second is the printer port. }
  PO_REN_PORT     = $0034;  { PO_RENAME and PO_PORTCHANGE at same time. }

{ no POF_ flags currently defined }

type
  PRINTEROP_FLAGS = Word;

{ implicit parameters are:
      if pFrom or pTo are unqualified names the current directories are
      taken from the global current drive/directory settings managed
      by Get/SetCurrentDrive/Directory

      the global confirmation settings }

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _SHFILEOPSTRUCT = packed record
    Wnd: HWND;
    wFunc: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    pFrom: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pTo: string;
    fFlags: FILEOP_FLAGS;
    fAnyOperationsAborted: BOOL;
    hNameMappings: IntPtr; { Pointer }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszProgressTitle: string; { only used if FOF_SIMPLEPROGRESS }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _SHFILEOPSTRUCTA = packed record
    Wnd: HWND;
    wFunc: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    pFrom: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pTo: string;
    fFlags: FILEOP_FLAGS;
    fAnyOperationsAborted: BOOL;
    hNameMappings: IntPtr; { Pointer }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszProgressTitle: string; { only used if FOF_SIMPLEPROGRESS }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _SHFILEOPSTRUCTW = packed record
    Wnd: HWND;
    wFunc: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    pFrom: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pTo: string;
    fFlags: FILEOP_FLAGS;
    fAnyOperationsAborted: BOOL;
    hNameMappings: IntPtr; { Pointer }
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszProgressTitle: string; { only used if FOF_SIMPLEPROGRESS }
  end;
  TSHFileOpStruct = _SHFILEOPSTRUCT;
  TSHFileOpStructA = _SHFILEOPSTRUCTA;
  TSHFileOpStructW = _SHFILEOPSTRUCTW;
  SHFILEOPSTRUCT = _SHFILEOPSTRUCT;
  SHFILEOPSTRUCTA = _SHFILEOPSTRUCTA;
  SHFILEOPSTRUCTW = _SHFILEOPSTRUCTW;

function SHFileOperation(const lpFileOp: TSHFileOpStruct): Integer;
function SHFileOperationA(const lpFileOp: TSHFileOpStructA): Integer;
function SHFileOperationW(const lpFileOp: TSHFileOpStructW): Integer;
procedure SHFreeNameMappings(hNameMappings: THandle);

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _SHNAMEMAPPING = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pszOldPath: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pszNewPath: string;
    cchOldPath: Integer;
    cchNewPath: Integer;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _SHNAMEMAPPINGA = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pszOldPath: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pszNewPath: string;
    cchOldPath: Integer;
    cchNewPath: Integer;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _SHNAMEMAPPINGW = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pszOldPath: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pszNewPath: string;
    cchOldPath: Integer;
    cchNewPath: Integer;
  end;
  TSHNameMapping = _SHNAMEMAPPING;
  TSHNameMappingA = _SHNAMEMAPPINGA;
  TSHNameMappingW = _SHNAMEMAPPINGW;
  SHNAMEMAPPING = _SHNAMEMAPPING;
  SHNAMEMAPPINGA = _SHNAMEMAPPINGA;
  SHNAMEMAPPINGW = _SHNAMEMAPPINGW;


{ ShellExecute() and ShellExecuteEx() error codes }
const
{ regular WinExec() codes }
  SE_ERR_FNF              = 2;       { file not found }
  SE_ERR_PNF              = 3;       { path not found }
  SE_ERR_ACCESSDENIED     = 5;       { access denied }
  SE_ERR_OOM              = 8;       { out of memory }
  SE_ERR_DLLNOTFOUND      = 32;

{ error values for ShellExecute() beyond the regular WinExec() codes }
  SE_ERR_SHARE                    = 26;
  SE_ERR_ASSOCINCOMPLETE          = 27;
  SE_ERR_DDETIMEOUT               = 28;
  SE_ERR_DDEFAIL                  = 29;
  SE_ERR_DDEBUSY                  = 30;
  SE_ERR_NOASSOC                  = 31;

{ Note CLASSKEY overrides CLASSNAME }
  SEE_MASK_CLASSNAME      = $00000001;
  SEE_MASK_CLASSKEY       = $00000003;
{ Note INVOKEIDLIST overrides IDLIST }
  SEE_MASK_IDLIST         = $00000004;
  SEE_MASK_INVOKEIDLIST   = $0000000c;
  SEE_MASK_ICON           = $00000010;
  SEE_MASK_HOTKEY         = $00000020;
  SEE_MASK_NOCLOSEPROCESS = $00000040;
  SEE_MASK_CONNECTNETDRV  = $00000080;
  SEE_MASK_FLAG_DDEWAIT   = $00000100;
  SEE_MASK_DOENVSUBST     = $00000200;
  SEE_MASK_FLAG_NO_UI     = $00000400;
  SEE_MASK_UNICODE        = $00010000; // !!! changed from previous SDK (was $00004000)
  SEE_MASK_NO_CONSOLE     = $00008000;
  SEE_MASK_ASYNCOK        = $00100000;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _SHELLEXECUTEINFO = record
    cbSize: DWORD;
    fMask: ULONG;
    Wnd: HWND;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpVerb: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpParameters: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDirectory: string;
    nShow: Integer;
    hInstApp: HINST;
    { Optional fields }
    lpIDList: IntPtr;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpClass: string;
    hkeyClass: HKEY;
    dwHotKey: DWORD;
    hIcon: THandle;
    hProcess: THandle;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _SHELLEXECUTEINFOA = record
    cbSize: DWORD;
    fMask: ULONG;
    Wnd: HWND;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpVerb: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpParameters: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDirectory: string;
    nShow: Integer;
    hInstApp: HINST;
    { Optional fields }
    lpIDList: IntPtr;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpClass: string;
    hkeyClass: HKEY;
    dwHotKey: DWORD;
    hIcon: THandle;
    hProcess: THandle;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _SHELLEXECUTEINFOW = record
    cbSize: DWORD;
    fMask: ULONG;
    Wnd: HWND;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpVerb: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpParameters: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDirectory: string;
    nShow: Integer;
    hInstApp: HINST;
    { Optional fields }
    lpIDList: IntPtr;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpClass: string;
    hkeyClass: HKEY;
    dwHotKey: DWORD;
    hIcon: THandle;
    hProcess: THandle;
  end;
  TShellExecuteInfo = _SHELLEXECUTEINFO;
  TShellExecuteInfoA = _SHELLEXECUTEINFOA;
  TShellExecuteInfoW = _SHELLEXECUTEINFOW;
  SHELLEXECUTEINFO = _SHELLEXECUTEINFO;
  SHELLEXECUTEINFOA = _SHELLEXECUTEINFOA;
  SHELLEXECUTEINFOW = _SHELLEXECUTEINFOW;

function ShellExecuteEx(const lpExecInfo: TShellExecuteInfo): BOOL;
function ShellExecuteExA(const lpExecInfo: TShellExecuteInfoA): BOOL;
function ShellExecuteExW(const lpExecInfo: TShellExecuteInfoW): BOOL;

{ Tray notification definitions }

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _NOTIFYICONDATA = record
    cbSize: DWORD;
    Wnd: HWND;
    uID: UINT;
    uFlags: UINT;
    uCallbackMessage: UINT;
    hIcon: HICON;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=64)]
    szTip: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _NOTIFYICONDATAA = record
    cbSize: DWORD;
    Wnd: HWND;
    uID: UINT;
    uFlags: UINT;
    uCallbackMessage: UINT;
    hIcon: HICON;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=64)]
    szTip: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _NOTIFYICONDATAW = record
    cbSize: DWORD;
    Wnd: HWND;
    uID: UINT;
    uFlags: UINT;
    uCallbackMessage: UINT;
    hIcon: HICON;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=64)]
    szTip: string;
  end;
  TNotifyIconData = _NOTIFYICONDATA;
  TNotifyIconDataA = _NOTIFYICONDATAA;
  TNotifyIconDataW = _NOTIFYICONDATAW;
  NOTIFYICONDATA = _NOTIFYICONDATA;
  NOTIFYICONDATAA = _NOTIFYICONDATAA;
  NOTIFYICONDATAW = _NOTIFYICONDATAW;

const
  NIM_ADD         = $00000000;
  NIM_MODIFY      = $00000001;
  NIM_DELETE      = $00000002;

  NIF_MESSAGE     = $00000001;
  NIF_ICON        = $00000002;
  NIF_TIP         = $00000004;

function Shell_NotifyIcon(dwMessage: DWORD; const lpData: TNotifyIconData): BOOL;
function Shell_NotifyIconA(dwMessage: DWORD; const lpData: TNotifyIconDataA): BOOL;
function Shell_NotifyIconW(dwMessage: DWORD; const lpData: TNotifyIconDataW): BOOL;

{ Begin SHGetFileInfo }

(*
 * The SHGetFileInfo API provides an easy way to get attributes
 * for a file given a pathname.
 *
 *   PARAMETERS
 *
 *     pszPath              file name to get info about
 *     dwFileAttributes     file attribs, only used with SHGFI_USEFILEATTRIBUTES
 *     psfi                 place to return file info
 *     cbFileInfo           size of structure
 *     uFlags               flags
 *
 *   RETURN
 *     TRUE if things worked
 *)

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _SHFILEINFO = record
    hIcon: HICON;                      { out: icon }
    iIcon: Integer;                    { out: icon index }
    dwAttributes: DWORD;               { out: SFGAO_ flags }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PATH)]
    szDisplayName: string;              { out: display name (or path) }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=80)]
    szTypeName: string;                { out: type name }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _SHFILEINFOA = record
    hIcon: HICON;                      { out: icon }
    iIcon: Integer;                    { out: icon index }
    dwAttributes: DWORD;               { out: SFGAO_ flags }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PATH)]
    szDisplayName: string;              { out: display name (or path) }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=80)]
    szTypeName: string;                { out: type name }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _SHFILEINFOW = record
    hIcon: HICON;                      { out: icon }
    iIcon: Integer;                    { out: icon index }
    dwAttributes: DWORD;               { out: SFGAO_ flags }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_PATH)]
    szDisplayName: string;              { out: display name (or path) }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=80)]
    szTypeName: string;                { out: type name }
  end;
  TSHFileInfo = _SHFILEINFO;
  TSHFileInfoA = _SHFILEINFOA;
  TSHFileInfoW = _SHFILEINFOW;
  SHFILEINFO = _SHFILEINFO;
  SHFILEINFOA = _SHFILEINFOA;
  SHFILEINFOW = _SHFILEINFOW;

const
  SHGFI_ICON              = $000000100;     { get icon }
  SHGFI_DISPLAYNAME       = $000000200;     { get display name }
  SHGFI_TYPENAME          = $000000400;     { get type name }
  SHGFI_ATTRIBUTES        = $000000800;     { get attributes }
  SHGFI_ICONLOCATION      = $000001000;     { get icon location }
  SHGFI_EXETYPE           = $000002000;     { return exe type }
  SHGFI_SYSICONINDEX      = $000004000;     { get system icon index }
  SHGFI_LINKOVERLAY       = $000008000;     { put a link overlay on icon }
  SHGFI_SELECTED          = $000010000;     { show icon in selected state }
  SHGFI_LARGEICON         = $000000000;     { get large icon }
  SHGFI_SMALLICON         = $000000001;     { get small icon }
  SHGFI_OPENICON          = $000000002;     { get open icon }
  SHGFI_SHELLICONSIZE     = $000000004;     { get shell size icon }
  SHGFI_PIDL              = $000000008;     { pszPath is a pidl }
  SHGFI_USEFILEATTRIBUTES = $000000010;     { use passed dwFileAttribute }

function SHGetFileInfo(pszPath: string; dwFileAttributes: DWORD;
  out psfi: TSHFileInfo; cbFileInfo, uFlags: UINT): DWORD; overload;
function SHGetFileInfo(pszPath: IntPtr; dwFileAttributes: DWORD;
  out psfi: TSHFileInfo; cbFileInfo, uFlags: UINT): DWORD; overload;
function SHGetFileInfoA(pszPath: string; dwFileAttributes: DWORD;
  out psfi: TSHFileInfoA; cbFileInfo, uFlags: UINT): DWORD;
function SHGetFileInfoW(pszPath: string; dwFileAttributes: DWORD;
  out psfi: TSHFileInfoW; cbFileInfo, uFlags: UINT): DWORD;

const
  SHGNLI_PIDL             = $000000001;     { pszLinkTo is a pidl }
  SHGNLI_PREFIXNAME       = $000000002;     { Make name "Shortcut to xxx" }
  SHGNLI_NOUNIQUE         = $000000004;     { don't do the unique name generation }

  shell32 = 'shell32.dll';

implementation

[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CommandLineToArgvW')]
function CommandLineToArgvW; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DoEnvironmentSubst')]
function DoEnvironmentSubst; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DoEnvironmentSubstA')]
function DoEnvironmentSubstA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DoEnvironmentSubstW')]
function DoEnvironmentSubstW; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DragAcceptFiles')]
procedure DragAcceptFiles; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DragFinish')]
procedure DragFinish; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DragQueryFile')]
function DragQueryFile; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DragQueryFileA')]
function DragQueryFileA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DragQueryFileW')]
function DragQueryFileW; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DragQueryPoint')]
function DragQueryPoint; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DuplicateIcon')]
function DuplicateIcon; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExtractAssociatedIcon')]
function ExtractAssociatedIcon; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtractAssociatedIconA')]
function ExtractAssociatedIconA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ExtractAssociatedIconW')]
function ExtractAssociatedIconW; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExtractIcon')]
function ExtractIcon; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtractIconA')]
function ExtractIconA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ExtractIconW')]
function ExtractIconW; external;

[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExtractIconEx')]
function ExtractIconEx(lpszFile: string; nIconIndex: Integer;
  [out] phiconLarge, [out] phiconSmall: array of HICON; nIcons: UINT): UINT; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExtractIconEx')]
function ExtractIconEx(lpszFile: string; nIconIndex: Integer;
  phiconLarge: IntPtr; [out] phiconSmall: array of HICON; nIcons: UINT): UINT; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExtractIconEx')]
function ExtractIconEx(lpszFile: string; nIconIndex: Integer;
  [out] phiconLarge: array of HICON; phiconSmall: IntPtr; nIcons: UINT): UINT; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ExtractIconEx')]
function ExtractIconEx(lpszFile: string; nIconIndex: Integer;
  phiconLarge, phiconSmall: IntPtr; nIcons: UINT): UINT; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ExtractIconExA')]
function ExtractIconExA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ExtractIconExW')]
function ExtractIconExW; external;

[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindExecutable')]
function FindExecutable; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindExecutableA')]
function FindExecutableA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindExecutableW')]
function FindExecutableW; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SHAppBarMessage')]
function SHAppBarMessage; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SHFileOperation')]
function SHFileOperation; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SHFileOperationA')]
function SHFileOperationA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SHFileOperationW')]
function SHFileOperationW; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SHFreeNameMappings')]
procedure SHFreeNameMappings; external;

[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SHGetFileInfo')]
function SHGetFileInfo(pszPath: string; dwFileAttributes: DWORD;
  out psfi: TSHFileInfo; cbFileInfo, uFlags: UINT): DWORD; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SHGetFileInfo')]
function SHGetFileInfo(pszPath: IntPtr; dwFileAttributes: DWORD;
  out psfi: TSHFileInfo; cbFileInfo, uFlags: UINT): DWORD; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SHGetFileInfoA')]
function SHGetFileInfoA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SHGetFileInfoW')]
function SHGetFileInfoW; external;

[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ShellAbout')]
function ShellAbout; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ShellAboutA')]
function ShellAboutA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ShellAboutW')]
function ShellAboutW; external;

[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ShellExecute')]
function ShellExecute(hWnd: HWND; Operation, FileName, Parameters,
  Directory: string; ShowCmd: Integer): HINST; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ShellExecute')]
function ShellExecute(hWnd: HWND; Operation: IntPtr; FileName, Parameters,
  Directory: string; ShowCmd: Integer): HINST; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ShellExecute')]
function ShellExecute(hWnd: HWND; Operation, FileName: string; Parameters: IntPtr;
  Directory: string; ShowCmd: Integer): HINST; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ShellExecute')]
function ShellExecute(hWnd: HWND; Operation: IntPtr; FileName: string; Parameters: IntPtr;
  Directory: string; ShowCmd: Integer): HINST; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ShellExecute')]
function ShellExecute(hWnd: HWND; Operation: IntPtr; FileName: string; Parameters: IntPtr;
  Directory: IntPtr; ShowCmd: Integer): HINST; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ShellExecute')]
function ShellExecute(hWnd: HWND; Operation: string; FileName: string; Parameters: string;
  Directory: IntPtr; ShowCmd: Integer): HINST; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ShellExecuteA')]
function ShellExecuteA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ShellExecuteW')]
function ShellExecuteW; external;

[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ShellExecuteEx')]
function ShellExecuteEx; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ShellExecuteExA')]
function ShellExecuteExA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ShellExecuteExW')]
function ShellExecuteExW; external;
[DllImport(shell32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'Shell_NotifyIcon')]
function Shell_NotifyIcon; external;
[DllImport(shell32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'Shell_NotifyIconA')]
function Shell_NotifyIconA; external;
[DllImport(shell32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'Shell_NotifyIconW')]
function Shell_NotifyIconW; external;

end.
